<?php

// Add info about Woocommerce support
add_action('after_setup_theme', 'woocommerce_support');
function woocommerce_support() {
add_theme_support('woocommerce');
}

// Remove / add hook
remove_action( 'woocommerce_before_shop_loop', 'woocommerce_result_count', 20 );

// Change number of products per row to 3
add_filter('loop_shop_columns', 'loop_columns');
if (!function_exists('loop_columns')) {
	function loop_columns() {
		return 3;
	}
}

/* Set placeholder when photo is not set*/
add_action( 'init', 'custom_fix_thumbnail' );
 
function custom_fix_thumbnail() {
  add_filter('woocommerce_placeholder_img_src', 'custom_woocommerce_placeholder_img_src');
   
	function custom_woocommerce_placeholder_img_src( $src ) {
	$src = get_template_directory_uri() . '/includes/img/page-thumb-shop.jpg';
	 
	return $src;
	}
}

/* Change sale text */
add_filter( 'woocommerce_sale_flash', 'wc_custom_replace_sale_text' );
function wc_custom_replace_sale_text( $html ) {
    return str_replace( __( 'Sale!', 'woocommerce' ), __( 'Sale', 'woocommerce' ), $html );
}

/* Change add to cart button text */
add_filter( 'woocommerce_product_add_to_cart_text' , 'custom_woocommerce_product_add_to_cart_text' );
/**
 * custom_woocommerce_template_loop_add_to_cart
*/
function custom_woocommerce_product_add_to_cart_text() {
	global $product;	
	$product_type = $product->product_type;	
	switch ( $product_type ) {
		case 'simple':
			return __( 'To basket', '_tk' );
		break;
		default:
			return __( 'Read more', '_tk' );
	}	
}

// Price variations - hide max price
add_filter( 'woocommerce_variable_sale_price_html', 'hide_variable_max_price', PHP_INT_MAX, 2 );
add_filter( 'woocommerce_variable_price_html',      'hide_variable_max_price', PHP_INT_MAX, 2 );
function hide_variable_max_price( $price, $_product ) {
    if (!is_product() ) {
		$min_price_regular = $_product->get_variation_regular_price( 'min', true );
		$min_price_sale    = $_product->get_variation_sale_price( 'min', true );
		$max_price_regular = $_product->get_variation_regular_price( 'max', true );
		$max_price_sale    = $_product->get_variation_sale_price( 'max', true );
		if ($min_price_regular == $max_price_regular or $min_price_sale == $max_price_sale or $min_price_regular == $max_price_sale or $min_price_sale == $max_price_regular) {
			return ( $min_price_sale == $min_price_regular ) ?
				'<span class="variation variation-normal">'.wc_price( $min_price_regular ).'</span>' :
				'<del>' . wc_price( $min_price_regular ) . '</del>' . '<ins>' . wc_price( $min_price_sale ) . '</ins>';
			
		} elseif ($min_price_sale) {
			return ( $min_price_sale == $min_price_regular ) ?
				'<span class="variation">'.wc_price( $min_price_regular ).'</span>' :
				'<del>' . wc_price( $min_price_regular ) . '</del>' . '<ins>' . wc_price( $min_price_sale ) . '</ins>';
		} else {
			return wc_price( $min_price_regular );
		}
	}
	if (is_product() ) {
		$min_price_regular = $_product->get_variation_regular_price( 'min', true );
		$min_price_sale    = $_product->get_variation_sale_price( 'min', true );
		$max_price_regular = $_product->get_variation_regular_price( 'max', true );
		$max_price_sale    = $_product->get_variation_sale_price( 'max', true );
		if ($min_price_regular == $max_price_regular or $min_price_sale == $max_price_sale or $min_price_regular == $max_price_sale or $min_price_sale == $max_price_regular) {
			return ( $min_price_sale == $min_price_regular ) ?
				wc_price( $min_price_regular ) :
				'<del>' . wc_price( $min_price_regular ) . '</del>' . '<ins>' . wc_price( $min_price_sale ) . '</ins>';
		} else {
			return '<p class="variable_price">Wybierz opcję, żeby zobaczyć cenę.</p>';
		}
	}
}
?>